/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.contraptions.fluids.particle.FluidStackParticle;
import com.simibubi.create.content.contraptions.particle.ICustomParticleData;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class FluidParticleData
implements ParticleOptions,
ICustomParticleData<FluidParticleData> {
    private ParticleType<FluidParticleData> type;
    private FluidStack fluid;
    public static final Codec<FluidParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)FluidStack.CODEC.fieldOf("fluid").forGetter(p -> p.fluid)).apply((Applicative)i, fs -> new FluidParticleData(AllParticleTypes.FLUID_PARTICLE.get(), (FluidStack)fs)));
    public static final Codec<FluidParticleData> BASIN_CODEC = RecordCodecBuilder.create(i -> i.group((App)FluidStack.CODEC.fieldOf("fluid").forGetter(p -> p.fluid)).apply((Applicative)i, fs -> new FluidParticleData(AllParticleTypes.BASIN_FLUID.get(), (FluidStack)fs)));
    public static final Codec<FluidParticleData> DRIP_CODEC = RecordCodecBuilder.create(i -> i.group((App)FluidStack.CODEC.fieldOf("fluid").forGetter(p -> p.fluid)).apply((Applicative)i, fs -> new FluidParticleData(AllParticleTypes.FLUID_DRIP.get(), (FluidStack)fs)));
    public static final ParticleOptions.Deserializer<FluidParticleData> DESERIALIZER = new ParticleOptions.Deserializer<FluidParticleData>(){

        public FluidParticleData fromCommand(ParticleType<FluidParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            return new FluidParticleData(particleTypeIn, new FluidStack((Fluid)Fluids.f_76193_, 1));
        }

        public FluidParticleData fromNetwork(ParticleType<FluidParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new FluidParticleData(particleTypeIn, buffer.readFluidStack());
        }
    };

    public FluidParticleData() {
    }

    public FluidParticleData(ParticleType<?> type, FluidStack fluid) {
        this.type = type;
        this.fluid = fluid;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ParticleProvider<FluidParticleData> getFactory() {
        return (data, world, x, y, z, vx, vy, vz) -> FluidStackParticle.create(data.type, world, data.fluid, x, y, z, vx, vy, vz);
    }

    public ParticleType<?> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFluidStack(this.fluid);
    }

    public String m_5942_() {
        return RegisteredObjects.getKeyOrThrow(this.type) + " " + RegisteredObjects.getKeyOrThrow(this.fluid.getFluid());
    }

    @Override
    public ParticleOptions.Deserializer<FluidParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    @Override
    public Codec<FluidParticleData> getCodec(ParticleType<FluidParticleData> type) {
        if (type == AllParticleTypes.BASIN_FLUID.get()) {
            return BASIN_CODEC;
        }
        if (type == AllParticleTypes.FLUID_DRIP.get()) {
            return DRIP_CODEC;
        }
        return CODEC;
    }
}

